CREATE DATABASE IF NOT EXISTS db_popjasa;
USE db_popjasa;

-- 1. Tabel Admin
CREATE TABLE IF NOT EXISTS `admin` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `admin` (`username`, `password`, `nama_lengkap`) VALUES 
('admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator POPJASA');

-- 2. Tabel Artikel (Database Pusat Artikel)
CREATE TABLE IF NOT EXISTS `articles` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `articles` (`title`) VALUES 
('PENTINGNYA AKTA NOTARIS'), 
('MANFAAT NPWP BADAN'), 
('SYARAT OSS RBA'), 
('IZIN EDAR BPOM'), 
('LEGALITAS CV TERBARU'),
('TIPS PAJAK UMKM'),
('CARA DAFTAR MEREK HAKI'),
('PANDUAN PENDIRIAN PT 2026');

-- 3. Tabel Pin Artikel Home (Relasi ke Tabel Artikel)
CREATE TABLE IF NOT EXISTS `home_pinned_articles` (
  `slot` int(11) PRIMARY KEY,
  `article_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_pinned_articles` (`slot`, `article_id`) VALUES 
(1, 8), (2, 7), (3, 6);

-- 4. Tabel Testimoni Whatsapp (Slider Chat)
CREATE TABLE IF NOT EXISTS `home_chat_slides` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_chat_slides` (`image`, `label`) VALUES 
('chat1.jpg', 'TESTIMONI CLIENT SURABAYA #1'),
('chat2.jpg', 'TESTIMONI CLIENT SIDOARJO #1'),
('chat3.jpg', 'TESTIMONI IZIN PT MALANG'),
('chat4.jpg', 'KLIEN PIRT GRESIK'),
('chat5.jpg', 'PENGURUSAN NIB JAKARTA');

-- 5. Tabel Trusted Partners (Logo Instansi)
CREATE TABLE IF NOT EXISTS `home_partners` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_partners` (`image`, `label`) VALUES 
('oss.png', 'INSTANSI OSS RBA'),
('kemenkumham.png', 'KEMENTERIAN HUKUM DAN HAM'),
('pajak.png', 'DITJEN PAJAK INDONESIA'),
('bpom.png', 'BADAN PENGAWAS OBAT DAN MAKANAN'),
('mui.png', 'MAJELIS ULAMA INDONESIA');

-- 6. Tabel FAQ (Tanya Jawab)
CREATE TABLE IF NOT EXISTS `home_faq` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `question` text NOT NULL,
  `answer` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_faq` (`question`, `answer`) VALUES 
('BERAPA LAMA PROSES PEMBUATAN PT?', 'PROSES PENGERJAAN SEKITAR 7-10 HARI KERJA SETELAH DOKUMEN LENGKAP.'),
('APAKAH BISA URUS NPWP PRIBADI?', 'BISA, KAMI MELAYANI ADMINISTRASI PERPAJAKAN BAIK PRIBADI MAUPUN BADAN.'),
('SYARAT UTAMA PENDIRIAN CV APA SAJA?', 'CUKUP KTP, KK, DAN NPWP PARA PENDIRI SERTA ALAMAT USAHA.'),
('APAKAH MELAYANI SELURUH INDONESIA?', 'YA, POPJASA MEMILIKI 9 CABANG DAN MELAYANI SECARA NASIONAL.'),
('BAGAIMANA SISTEM PEMBAYARANNYA?', 'PEMBAYARAN DAPAT DILAKUKAN VIA TRANSFER KE REKENING RESMI PERUSAHAAN.');