<?php
session_start();
// Pastikan path database.php sudah benar
include '../config/database.php';

if (isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit;
}

$error = "";
if (isset($_POST['login_action'])) { // Diubah agar tidak bentrok dengan ID/Class
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = md5($_POST['password']);

    $query = "SELECT * FROM admin WHERE username='$username' AND password='$password'";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) === 1) {
        $row = mysqli_fetch_assoc($result);
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_id'] = $row['id'];
        $_SESSION['admin_nama'] = $row['nama_lengkap'];
        
        mysqli_query($conn, "UPDATE admin SET last_login = NOW() WHERE id = " . $row['id']);
        header("Location: index.php");
        exit;
    } else {
        $error = "Email atau password salah!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - POP JASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-[#1e293b] h-screen flex items-center justify-center p-0 md:p-6">

    <div class="flex flex-col md:flex-row w-full max-w-6xl h-full md:h-[650px] bg-white rounded-none md:rounded-3xl overflow-hidden shadow-2xl">
        
        <div class="w-full md:w-1/2 bg-[#1e293b] p-10 md:p-16 text-white flex flex-col justify-center">
            <div class="mb-8">
                <img src="../assets/images/pjs.png" alt="Logo Popjasa" class="h-20 w-auto">
            </div>
            
            <h2 class="text-3xl font-bold mb-6 leading-tight">POP Jasa Solusi Perizinan <br>Usaha Anda</h2>
            
            <div class="space-y-4 text-slate-300 text-sm md:text-base leading-relaxed">
                <p>
                    <span class="text-white font-semibold">POP JASA</span> adalah perusahaan penyedia layanan jasa legalitas yang berfokus pada pemberian solusi <span class="text-white">komprehensif dan profesional</span> untuk mendukung kebutuhan legal usaha Anda.
                </p>
                <p>Kami mengutamakan <span class="text-white">kecepatan, akurasi, dan transparansi</span> dalam setiap proses layanan.</p>
                
                <div class="pt-6 mt-6 border-t border-slate-700">
                    <p class="text-xs uppercase tracking-widest text-slate-500 mb-3 font-bold">Tentang Kami</p>
                    <p class="text-xs leading-relaxed">
                        Dengan pengalaman bertahun-tahun, POP JASA menghadirkan layanan profesional untuk pengurusan <b>CV, PT, UD, PT Perorangan, Yayasan, Perkumpulan, Koperasi, PIRT, BPOM, hingga digital marketing dan perpajakan.</b>
                    </p>
                    <p class="mt-4 text-xs">
                        Kami percaya bahwa <span class="text-white font-bold">keberhasilan bisnis Anda dimulai dari legalitas yang kuat.</span>
                    </p>
                </div>
            </div>
        </div>

        <div class="w-full md:w-1/2 bg-[#f1f5f9] p-10 md:p-20 flex flex-col justify-center relative">
            <div class="w-full max-w-sm mx-auto">
                <h2 class="text-4xl font-bold text-slate-800 mb-2">Login Admin</h2>
                <p class="text-slate-500 mb-10">Masuk untuk mengelola sistem</p>

                <?php if($error): ?>
                    <div class="bg-red-500 text-white px-4 py-3 rounded-lg mb-6 text-sm animate-pulse">
                        <i class="fas fa-exclamation-circle mr-2"></i> <?= $error ?>
                    </div>
                <?php endif; ?>

                <form action="" method="POST">
                    <div class="mb-6">
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Email</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-4 text-slate-400">
                                <i class="fas fa-envelope"></i>
                            </span>
                            <input type="email" name="username" required
                                class="w-full pl-12 pr-4 py-4 bg-[#e2e8f0] border-2 border-transparent focus:border-blue-500 focus:bg-white rounded-xl outline-none transition-all text-slate-800"
                                placeholder="admin@gmail.com">
                        </div>
                    </div>

                    <div class="mb-2">
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Password</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-4 text-slate-400">
                                <i class="fas fa-lock"></i>
                            </span>
                            <input type="password" name="password" id="pass" required
                                class="w-full pl-12 pr-12 py-4 bg-[#e2e8f0] border-2 border-transparent focus:border-blue-500 focus:bg-white rounded-xl outline-none transition-all text-slate-800"
                                placeholder="••••••">
                            <button type="button" onclick="toggleView()" class="absolute inset-y-0 right-0 flex items-center pr-4 text-slate-400 hover:text-blue-500">
                                <i class="fas fa-eye" id="eye-icon"></i>
                            </button>
                        </div>
                    </div>

                    <div class="text-right mb-8">
                        <a href="#" class="text-sm text-slate-500 hover:text-blue-600 transition-colors">Lupa password?</a>
                    </div>

                    <button type="submit" name="login_action"
                        class="w-full bg-[#0f172a] hover:bg-black text-white font-bold py-4 rounded-xl transition-all shadow-xl flex items-center justify-center gap-3 group">
                        <span>Login</span>
                        <i class="fas fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                    </button>
                </form>

                <div class="mt-16 text-center">
                    <p class="text-[10px] text-slate-400 uppercase tracking-[0.2em]">
                        © 2025 POP JASA SOLUSI PERIZINAN USAHA ANDA • ALL RIGHTS RESERVED
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleView() {
            const p = document.getElementById('pass');
            const icon = document.getElementById('eye-icon');
            if (p.type === 'password') {
                p.type = 'text';
                icon.classList.replace('fa-eye', 'fa-eye-slash');
            } else {
                p.type = 'password';
                icon.classList.replace('fa-eye-slash', 'fa-eye');
            }
        }
    </script>
</body>
</html>