<?php
session_start();
include '../../config/database.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// Simulasi data kantor (Nanti diganti query: SELECT * FROM kantor WHERE id = 1)
$kantor = [
    'nama' => 'POP Jasa Solusi Perizinan Usaha Anda',
    'hp' => '08563162047',
    'email' => 'popjasa@gmail.com',
    'alamat' => 'Ruko Mezzanine Blok A-25, Jl. Nginden Semolo No. 3',
    'maps' => 'https://maps.app.goo.gl/WvmRnZLPdKmSkMQk6',
    'fb' => 'https://www.facebook.com/popjasa',
    'ig' => 'https://www.instagram.com/popjasa',
    'tiktok' => 'https://www.tiktok.com/@popjasa',
    'youtube' => 'https://www.youtube.com/@popjasa'
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Data Kantor - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #f4f7fe; }
        .sidebar { background-color: #212529; transition: all 0.3s; width: 280px; }
        .nav-link { color: #adb5bd; transition: all 0.2s; border-left: 4px solid transparent; cursor: pointer; }
        .nav-link:hover, .nav-link.active { background: #2c3136; color: white; border-left-color: #f97316; }
        .submenu { background-color: #1a1d20; display: none; }
        .submenu.show { display: block; }
        .glass-card { background: white; border-radius: 20px; border: 1px solid #edf2f7; box-shadow: 0 10px 25px rgba(0,0,0,0.02); }
        
        /* Form Styling */
        label { font-size: 11px; font-weight: 700; color: #64748b; text-transform: uppercase; margin-bottom: 8px; display: block; }
        input, textarea { 
            width: 100%; padding: 12px 16px; border-radius: 12px; border: 1px solid #e2e8f0; 
            font-size: 13px; font-weight: 600; color: #1e293b; outline: none; transition: all 0.3s;
        }
        input:focus, textarea:focus { border-color: #3b82f6; box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.05); }
    </style>
</head>
<body class="flex min-h-screen">

    <aside class="sidebar flex flex-col fixed h-full z-50">
        <div class="p-6 border-b border-gray-700">
            <div class="flex items-center gap-3">
                <img src="../../assets/images/pjs.png" alt="Logo" class="h-10">
                <div>
                    <h1 class="text-white text-xs font-bold leading-tight uppercase">Admin Panel</h1>
                    <p class="text-[10px] text-gray-400 italic">Pop Jasa System</p>
                </div>
            </div>
        </div>

        <nav class="flex-grow overflow-y-auto mt-4 text-sm font-semibold tracking-wide">
            <a href="../index.php" class="nav-link flex items-center gap-3 px-6 py-4">
                <i class="fas fa-gauge-high w-5"></i> Dashboard
            </a>

            <div>
                <div onclick="toggleSub('master-sub', 'master-icon')" class="nav-link active w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-database w-5 text-[10px]"></i> MASTER</span>
                    <i id="master-icon" class="fas fa-chevron-left text-[10px] -rotate-90 transition-transform"></i>
                </div>
                <div id="master-sub" class="submenu show pl-12 text-[11px]">
                    <a href="manage-admin.php" class="block py-3 text-gray-400 hover:text-white uppercase">Manajemen Admin</a>
                    <a href="manage-kantor.php" class="block py-3 text-white font-bold uppercase underline">Kantor</a>
                    <a href="manage-visi-misi.php" class="block py-3 text-gray-400 hover:text-white uppercase">Visi-Misi</a>
                    <a href="manage-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Klien</a>
                    <a href="manage-label.php" class="block py-3 text-gray-400 hover:text-white uppercase">Label</a>
                    <a href="manage-kelebihan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kelebihan</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('konten-sub', 'konten-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-desktop w-5 text-[10px]"></i> KONTEN WEBSITE</span>
                    <i id="konten-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="konten-sub" class="submenu pl-12 text-[11px]">
                    <a href="../konten/manage-artikel.php" class="block py-3 text-gray-400 hover:text-white uppercase">Artikel</a>
                    <a href="../konten/manage-banner.php" class="block py-3 text-gray-400 hover:text-white uppercase">Banner</a>
                    <a href="../konten/manage-galeri.php" class="block py-3 text-gray-400 hover:text-white uppercase">Galeri</a>
                    <a href="../konten/manage-testimoni.php" class="block py-3 text-gray-400 hover:text-white uppercase">Testimoni</a>
                    <a href="../konten/manage-bukti-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Bukti Klien</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('layanan-sub', 'layanan-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-briefcase w-5 text-[10px]"></i> LAYANAN</span>
                    <i id="layanan-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="layanan-sub" class="submenu pl-12 text-[11px]">
                    <a href="../layanan/manage-ket-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Keterangan Layanan</a>
                    <a href="../layanan/manage-data-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Data Layanan</a>
                    <a href="../layanan/manage-layanan-legal.php" class="block py-3 text-gray-400 hover:text-white uppercase">Layanan Legal</a>
                    <a href="../layanan/manage-pelatih.php" class="block py-3 text-gray-400 hover:text-white uppercase">Pelatih</a>
                    <a href="../layanan/manage-pelatihan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Pelatihan</a>
                    <a href="../layanan/manage-affiliate.php" class="block py-3 text-gray-400 hover:text-white uppercase">Affiliate</a>
                </div>
            </div>

            <a href="../logout.php" class="btn-logout flex items-center gap-3 px-6 py-4 mt-10 transition-all font-bold">
                <i class="fas fa-power-off w-5 text-center"></i> Logout
            </a>
        </nav>
    </aside>

    <main class="flex-grow ml-[280px]">
        <header class="bg-white px-8 py-4 shadow-sm flex justify-between items-center sticky top-0 z-40">
            <div>
                <h2 class="text-xl font-bold text-gray-800 uppercase italic">Dashboard</h2>
                <p class="text-[10px] text-gray-500">Ringkasan aktivitas sistem</p>
            </div>
            <div class="flex items-center gap-3">
                <div class="text-right">
                    <p class="text-xs font-bold text-gray-800"><?= $_SESSION['admin_nama'] ?></p>
                    <p class="text-[10px] text-gray-500 italic">Administrator</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white border-2 border-orange-500 shadow-md">
                    <i class="fas fa-user-shield"></i>
                </div>
            </div>
        </header>

        <div class="p-8">
            <div class="glass-card p-6 mb-8 flex items-center gap-4">
                <div class="w-12 h-12 bg-blue-50 text-blue-600 rounded-xl flex items-center justify-center text-xl">
                    <i class="fas fa-building"></i>
                </div>
                <div>
                    <h3 class="text-2xl font-extrabold text-gray-800 tracking-tight">Edit Data Kantor</h3>
                    <p class="text-xs text-gray-500 font-medium">Kelola identitas dan informasi kantor</p>
                </div>
            </div>

            <form action="../functions/process-master.php" method="POST" enctype="multipart/form-data">
                <div class="glass-card p-10 space-y-8">
                    
                    <div class="space-y-4">
                        <label>Logo Kantor</label>
                        <p class="text-[9px] text-gray-400 font-bold uppercase">* Kosongkan jika tidak ingin mengganti logo</p>
                        <div class="flex items-center gap-6">
                            <div class="w-24 h-24 border rounded-2xl flex items-center justify-center p-3 bg-slate-50 overflow-hidden shadow-inner">
                                <img src="../../assets/images/pjs.png" class="object-contain max-h-full">
                            </div>
                            <input type="file" name="logo" class="text-xs file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-xs file:font-black file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition-all">
                        </div>
                    </div>

                    <div>
                        <label>Nama Kantor</label>
                        <input type="text" name="nama_kantor" value="<?= $kantor['nama'] ?>">
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label>No. HP</label>
                            <input type="text" name="no_hp" value="<?= $kantor['hp'] ?>">
                        </div>
                        <div>
                            <label>Email</label>
                            <input type="email" name="email" value="<?= $kantor['email'] ?>">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label>Facebook</label>
                            <input type="text" name="fb" value="<?= $kantor['fb'] ?>">
                        </div>
                        <div>
                            <label>Instagram</label>
                            <input type="text" name="ig" value="<?= $kantor['ig'] ?>">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label>TikTok</label>
                            <input type="text" name="tiktok" value="<?= $kantor['tiktok'] ?>">
                        </div>
                        <div>
                            <label>YouTube</label>
                            <input type="text" name="youtube" value="<?= $kantor['youtube'] ?>">
                        </div>
                    </div>

                    <div>
                        <label>Alamat</label>
                        <textarea name="alamat" rows="3"><?= $kantor['alamat'] ?></textarea>
                    </div>

                    <div>
                        <label>Link Google Maps</label>
                        <input type="text" name="maps" value="<?= $kantor['maps'] ?>">
                    </div>

                    <div>
                        <label>Deskripsi</label>
                        <textarea id="editor" name="deskripsi">
                            <p><strong>POP JASA</strong> adalah perusahaan penyedia layanan jasa legalitas yang berfokus pada pemberian solusi <strong>komprehensif dan profesional</strong> untuk mendukung kebutuhan legal usaha Anda.</p>
                            <p>Kami mengutamakan <strong>kecepatan, akurasi, dan transparansi</strong> dalam setiap proses layanan.</p>
                            <p><strong>Tentang Kami</strong></p>
                            <p>Dengan pengalaman bertahun-tahun, POP JASA menghadirkan layanan profesional untuk pengurusan berbagai kebutuhan legal usaha, antara lain CV, PT, UD, PT Perorangan, Yayasan, Perkumpulan, Koperasi, PIRT, BPOM, hingga digital marketing dan perpajakan.</p>
                        </textarea>
                    </div>

                    <div class="flex justify-end pt-6">
                        <button type="submit" name="update_kantor" class="bg-blue-600 hover:bg-blue-700 text-white px-10 py-3 rounded-xl font-black text-xs shadow-lg shadow-blue-200 transition-all flex items-center gap-3 uppercase tracking-widest">
                            <i class="fas fa-save text-sm"></i> Simpan Perubahan
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </main>

    <script>
        // Fungsi Dropdown Sidebar
        function toggleSub(id, iconId) {
            const submenu = document.getElementById(id);
            const icon = document.getElementById(iconId);
            submenu.classList.toggle('show');
            icon.style.transform = submenu.classList.contains('show') ? 'rotate(-90deg)' : 'rotate(0deg)';
        }

        // Initialize TinyMCE
        tinymce.init({
            selector: '#editor',
            height: 350,
            plugins: 'lists link code table wordcount autoresize',
            toolbar: 'undo redo | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist | link code',
            skin: 'oxide',
            content_css: 'default',
            border_width: 0,
            menubar: false
        });
    </script>
</body>
</html>