<?php
session_start();
include '../../config/database.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// Data Dummy (Nanti ganti dengan query SQL: SELECT * FROM visi_misi ORDER BY jenis DESC)
$data_visi_misi = [
    ['id' => 1, 'jenis' => 'Misi', 'isi' => '<b>KONSUMEN</b> Menyediakan produk, layanan & solusi yang unggul serta berfokus pada kepuasan konsumen.'],
    ['id' => 2, 'jenis' => 'Misi', 'isi' => '<b>KARYAWAN</b> Menciptakan lingkungan kerja yang mendukung produktifitas dan kesejahteraan karyawan.'],
    ['id' => 3, 'jenis' => 'Misi', 'isi' => '<b>PERADABAN & SOSIAL</b> Berkontribusi nyata untuk meningkatkan kualitas hidup di masyarakat dan lingkungan.'],
    ['id' => 4, 'jenis' => 'Misi', 'isi' => '<b>MITRA BISNIS</b> Membantu mitra untuk mengembangkan bisnis yang inovatif dan saling menguntungkan.'],
    ['id' => 5, 'jenis' => 'Misi', 'isi' => '<b>STANDART INTERNASIONAL</b> Mencapai standar internasional dengan standarisasi ISO'],
    ['id' => 6, 'jenis' => 'Visi', 'isi' => 'Menjadi perusahaan digital global yang solutif, inovatif dan adaptif untuk membangun peradaban dan kesejahteraan bersama.'],
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Visi & Misi - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #f4f7fe; }
        .sidebar { background-color: #212529; width: 280px; transition: all 0.3s; }
        .nav-link { color: #adb5bd; transition: all 0.2s; border-left: 4px solid transparent; cursor: pointer; }
        .nav-link:hover, .nav-link.active { background: #2c3136; color: white; border-left-color: #f97316; }
        .submenu { background-color: #1a1d20; display: none; }
        .submenu.show { display: block; }
        .glass-card { background: white; border-radius: 20px; border: 1px solid #edf2f7; box-shadow: 0 10px 25px rgba(0,0,0,0.02); }
        .btn-logout { background-color: #dc3545; color: white; }
        
        /* Badge Visi Misi */
        .badge-misi { background-color: #ecfdf5; color: #10b981; }
        .badge-visi { background-color: #eef2ff; color: #6366f1; }
    </style>
</head>
<body class="flex min-h-screen">

    <aside class="sidebar flex flex-col fixed h-full z-50">
        <div class="p-6 border-b border-gray-700">
            <div class="flex items-center gap-3">
                <img src="../../assets/images/pjs.png" alt="Logo" class="h-10">
                <div>
                    <h1 class="text-white text-xs font-bold leading-tight uppercase">Admin Panel</h1>
                    <p class="text-[10px] text-gray-400 italic">Pop Jasa System</p>
                </div>
            </div>
        </div>

        <nav class="flex-grow overflow-y-auto mt-4 text-sm font-semibold tracking-wide text-[13px]">
            <a href="../index.php" class="nav-link flex items-center gap-3 px-6 py-4">
                <i class="fas fa-gauge-high w-5"></i> Dashboard
            </a>

            <div>
                <div onclick="toggleSub('master-sub', 'master-icon')" class="nav-link active w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-database w-5 text-[10px]"></i> MASTER</span>
                    <i id="master-icon" class="fas fa-chevron-left text-[10px] -rotate-90 transition-transform"></i>
                </div>
                <div id="master-sub" class="submenu show pl-12 text-[11px]">
                    <a href="manage-admin.php" class="block py-3 text-gray-400 hover:text-white uppercase">Manajemen Admin</a>
                    <a href="manage-kantor.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kantor</a>
                    <a href="manage-visi-misi.php" class="block py-3 text-white font-bold uppercase underline">Visi-Misi</a>
                    <a href="manage-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Klien</a>
                    <a href="manage-label.php" class="block py-3 text-gray-400 hover:text-white uppercase">Label</a>
                    <a href="manage-kelebihan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kelebihan</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('konten-sub', 'konten-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-desktop w-5 text-[10px]"></i> KONTEN WEBSITE</span>
                    <i id="konten-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="konten-sub" class="submenu pl-12 text-[11px]">
                    <a href="../konten/manage-artikel.php" class="block py-3 text-gray-400 hover:text-white uppercase">Artikel</a>
                    <a href="../konten/manage-banner.php" class="block py-3 text-gray-400 hover:text-white uppercase">Banner</a>
                    <a href="../konten/manage-galeri.php" class="block py-3 text-gray-400 hover:text-white uppercase">Galeri</a>
                    <a href="../konten/manage-testimoni.php" class="block py-3 text-gray-400 hover:text-white uppercase">Testimoni</a>
                    <a href="../konten/manage-bukti-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Bukti Klien</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('layanan-sub', 'layanan-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-briefcase w-5 text-[10px]"></i> LAYANAN</span>
                    <i id="layanan-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="layanan-sub" class="submenu pl-12 text-[11px]">
                    <a href="../layanan/manage-ket-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Keterangan Layanan</a>
                    <a href="../layanan/manage-data-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Data Layanan</a>
                    <a href="../layanan/manage-layanan-legal.php" class="block py-3 text-gray-400 hover:text-white uppercase">Layanan Legal</a>
                </div>
            </div>

            <a href="../logout.php" class="btn-logout flex items-center gap-3 px-6 py-4 mt-10 transition-all font-bold uppercase text-xs">
                <i class="fas fa-power-off w-5 text-center"></i> Logout
            </a>
        </nav>
    </aside>

    <main class="flex-grow ml-[280px]">
        <header class="bg-white px-8 py-4 shadow-sm flex justify-between items-center sticky top-0 z-40 border-b">
            <div>
                <h2 class="text-xl font-bold text-gray-800 uppercase italic">Dashboard</h2>
                <p class="text-[10px] text-gray-500">Ringkasan aktivitas sistem</p>
            </div>
            <div class="flex items-center gap-3">
                <div class="text-right">
                    <p class="text-xs font-bold text-gray-800"><?= $_SESSION['admin_nama'] ?></p>
                    <p class="text-[10px] text-gray-500 italic">Administrator</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white border-2 border-orange-500">
                    <i class="fas fa-user-shield"></i>
                </div>
            </div>
        </header>

        <div class="p-8">
            <div class="glass-card p-6 mb-8 flex flex-col md:flex-row justify-between items-center border-l-8 border-blue-600">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-xl flex items-center justify-center text-xl">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl font-extrabold text-gray-800 tracking-tight">Data Visi & Misi</h3>
                        <p class="text-xs text-gray-500 font-medium">Kelola visi dan misi perusahaan</p>
                    </div>
                </div>
                <button class="mt-4 md:mt-0 bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-xl font-bold text-sm shadow-lg shadow-blue-100 transition-all flex items-center gap-2">
                    <i class="fas fa-plus"></i> Tambah Data
                </button>
            </div>

            <div class="glass-card overflow-hidden">
                <div class="p-6 border-b border-gray-50 flex justify-between items-center bg-gray-50/30">
                    <div class="flex items-center gap-2 text-sm font-semibold text-gray-600">
                        Tampilkan 
                        <select class="border rounded-lg px-2 py-1 outline-none focus:ring-2 focus:ring-blue-400">
                            <option>10</option>
                            <option>25</option>
                        </select> 
                        data
                    </div>
                    <div class="relative">
                        <input type="text" placeholder="Cari data..." class="pl-4 pr-10 py-2 border rounded-xl outline-none focus:ring-2 focus:ring-blue-400 text-sm w-64">
                        <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
                    </div>
                </div>

                <div class="overflow-x-auto p-4">
                    <table class="w-full text-left">
                        <thead>
                            <tr class="text-[11px] font-black text-gray-400 uppercase tracking-widest border-b">
                                <th class="p-4 w-16 text-center">No</th>
                                <th class="p-4 w-24">Jenis</th>
                                <th class="p-4">Isi</th>
                                <th class="p-4 text-center w-48">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm font-semibold text-gray-700">
                            <?php $no = 1; foreach($data_visi_misi as $row): ?>
                            <tr class="border-b border-gray-50 hover:bg-slate-50 transition-colors">
                                <td class="p-5 text-center text-gray-400"><?= $no++ ?></td>
                                <td class="p-5">
                                    <span class="px-4 py-1.5 rounded-full text-[11px] font-bold <?= ($row['jenis'] == 'Misi') ? 'badge-misi' : 'badge-visi' ?>">
                                        <?= $row['jenis'] ?>
                                    </span>
                                </td>
                                <td class="p-5 leading-relaxed text-gray-600 font-medium">
                                    <?= $row['isi'] ?>
                                </td>
                                <td class="p-5 text-center">
                                    <div class="flex justify-center gap-2">
                                        <button class="bg-amber-50 text-amber-600 border border-amber-100 hover:bg-amber-500 hover:text-white px-3 py-1.5 rounded-lg text-xs font-black transition-all flex items-center gap-1">
                                            <i class="fas fa-edit text-[10px]"></i> Edit
                                        </button>
                                        <button class="bg-red-50 text-red-600 border border-red-100 hover:bg-red-500 hover:text-white px-3 py-1.5 rounded-lg text-xs font-black transition-all flex items-center gap-1">
                                            <i class="fas fa-trash text-[10px]"></i> Hapus
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="p-6 flex flex-col md:flex-row justify-between items-center gap-4 bg-gray-50/30 border-t">
                    <p class="text-xs font-bold text-gray-500 italic uppercase">Menampilkan 1 - 6 dari 6 data</p>
                    <div class="flex items-center gap-1">
                        <button class="w-8 h-8 flex items-center justify-center rounded-lg border bg-white text-gray-400 hover:bg-blue-600 transition"><i class="fas fa-chevron-left text-[10px]"></i></button>
                        <button class="w-8 h-8 flex items-center justify-center rounded-lg bg-blue-600 text-white text-xs font-bold shadow-md shadow-blue-100">1</button>
                        <button class="w-8 h-8 flex items-center justify-center rounded-lg border bg-white text-gray-400 hover:bg-blue-600 transition"><i class="fas fa-chevron-right text-[10px]"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
        // Fungsi Dropdown Sidebar
        function toggleSub(id, iconId) {
            const submenu = document.getElementById(id);
            const icon = document.getElementById(iconId);
            submenu.classList.toggle('show');
            icon.style.transform = submenu.classList.contains('show') ? 'rotate(-90deg)' : 'rotate(0deg)';
        }
    </script>
</body>
</html>