<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alur Proses - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        body { 
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; 
            scroll-behavior: smooth; 
        }
        .bg-gradient-indigo { background: linear-gradient(135deg, #0f172a 0%, #1e1b4b 50%, #312e81 100%); }
        .glass-nav { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
        
        /* Dropdown & Menu Animations */
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        #mobileMenu { transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); max-height: 0; opacity: 0; pointer-events: none; overflow: hidden; }
        #mobileMenu.active { max-height: 100vh; opacity: 1; pointer-events: auto; }

        /* Custom Card & Icon Animations */
        .sosmed-icon { transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .sosmed-icon:hover { transform: translateY(-8px) scale(1.15); filter: brightness(1.2); box-shadow: 0 10px 20px rgba(0,0,0,0.2); }
        
        .step-card { transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1); }
        .step-card:hover { transform: translateY(-15px); border-color: #4f46e5; box-shadow: 0 25px 50px -12px rgba(79, 70, 229, 0.25); }
        .step-card:hover .step-number { transform: scale(1.2) rotate(-5deg); color: #4f46e5; }
        .step-card:hover .step-icon-bg { background-color: #4f46e5; color: white; transform: rotate(360deg); }

        /* Gradient Text */
        .text-gradient { background: linear-gradient(to right, #4f46e5, #ec4899); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }

        /* Force Reset Italic */
        .italic, i, body { font-style: normal !important; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            <div class="flex items-center gap-3 animate__animated animate__fadeInLeft">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                    <div class="flex flex-col text-left leading-none">
                        <span class="text-xl font-extrabold tracking-tighter text-indigo-900">POPJASA</span>
                        <span class="text-[8px] font-bold text-orange-500 uppercase tracking-widest mt-1">Solusi Perijinan Usaha</span>
                    </div>
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm uppercase font-black animate__animated animate__fadeInDown">
                <a href="index.php" class="hover:text-indigo-600 transition">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-indigo-600 transition py-8 tracking-wider text-xs font-black">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 uppercase font-black text-left">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-b border-slate-50">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-b border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-b border-slate-50">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="text-indigo-600 transition uppercase text-xs font-black">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-indigo-600 transition uppercase text-xs font-black">Tentang Kami</a>
                <a href="program-affiliate.php" class="hover:text-indigo-600 transition uppercase text-xs font-black">Program Affiliate</a>
                <a href="artikel.php" class="hover:text-indigo-600 transition uppercase text-xs font-black">Artikel</a>
            </div>

            <div class="flex items-center gap-4 animate__animated animate__fadeInRight">
                <a href="https://wa.me/6281229995779" class="hidden sm:flex bg-green-500 text-white px-5 py-2.5 rounded-full font-black shadow-lg hover:bg-green-600 transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp text-lg"></i> Konsultasi
                </a>
                <button id="hamburgerBtn" class="lg:hidden text-indigo-900 text-2xl focus:outline-none transition hover:rotate-90"><i class="fas fa-bars"></i></button>
            </div>
        </div>
    </nav>

    <div id="mobileMenu" class="lg:hidden bg-white border-t border-slate-100 shadow-xl absolute w-full left-0 z-50 uppercase font-black">
        <div class="flex flex-col p-6 space-y-4 text-xs tracking-widest font-black">
            <a href="index.php" class="py-2 border-b border-slate-50 leading-tight">Beranda</a>
            <div onclick="document.getElementById('mobileSub').classList.toggle('hidden')" class="py-2 border-b border-slate-50 flex justify-between items-center cursor-pointer">
                <span>Layanan</span> <i class="fas fa-chevron-down text-[10px]"></i>
            </div>
            <div id="mobileSub" class="hidden flex flex-col pl-4 space-y-3 bg-slate-50 p-4 rounded-xl">
                <a href="jasa-perizinan.php">Jasa Perizinan</a>
                <a href="izin-lanjutan.php">Jasa Lanjutan</a>
                <a href="perpajakan.php">Perpajakan</a>
                <a href="digital-marketing.php">Digital Marketing</a>
            </div>
            <a href="alur-proses.php" class="py-2 border-b border-slate-50 leading-tight text-indigo-600">Alur Proses</a>
            <a href="tentang-kami.php" class="py-2 border-b border-slate-50 leading-tight">Tentang Kami</a>
            <a href="program-affiliate.php" class="py-2 border-b border-slate-50 leading-tight">Program Affiliate</a>
            <a href="artikel.php" class="py-2 border-b border-slate-50 leading-tight">Artikel</a>
        </div>
    </div>

    <section class="container mx-auto px-6 py-12">
        <div class="bg-gradient-indigo rounded-[50px] overflow-hidden flex flex-col lg:flex-row items-center relative min-h-[500px] animate__animated animate__zoomIn">
            <div class="p-12 lg:w-3/5 text-white z-10 leading-tight animate__animated animate__fadeInLeft animate__delay-1s">
                <span class="inline-block px-4 py-1 bg-white/10 rounded-full text-[10px] tracking-widest mb-6 border border-white/20">WORKFLOW TRANSPARANCY</span>
                <h1 class="text-5xl lg:text-7xl font-black mb-8 uppercase leading-none">Alur Kerja<br><span class="text-gradient">Terstruktur</span></h1>
                <p class="text-lg text-slate-300 mb-10 leading-relaxed max-w-xl font-bold">
                    Kami menjamin transparansi di setiap tahapan pengerjaan. Dari validasi berkas hingga pengiriman dokumen ke tangan Anda.
                </p>
                <div class="flex flex-wrap gap-4">
                    <button class="bg-white text-indigo-900 px-10 py-4 rounded-2xl font-black text-xs uppercase shadow-xl hover:bg-slate-100 transition-all hover:scale-105 active:scale-95">
                        Lihat Prosedur Lengkap
                    </button>
                    <a href="https://wa.me/6281229995779" class="bg-green-500/20 backdrop-blur-md border border-green-500/30 text-green-400 px-10 py-4 rounded-2xl font-black text-xs uppercase hover:bg-green-500/30 transition-all">
                        Chat Admin
                    </a>
                </div>
            </div>
            <div class="lg:w-2/5 w-full h-full min-h-[350px] relative overflow-hidden flex items-center justify-center p-12">
                <div class="absolute inset-0 bg-indigo-500/20 animate-pulse"></div>
                <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover rounded-[40px] shadow-2xl relative z-10 transform rotate-3 hover:rotate-0 transition-all duration-700 opacity-90 grayscale hover:grayscale-0">
            </div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 text-center">
        <h2 class="text-4xl font-extrabold mb-4 tracking-tighter animate__animated animate__fadeInUp">8 Langkah Menuju Legalitas</h2>
        <p class="text-slate-500 font-bold text-sm mb-20 uppercase animate__animated animate__fadeInUp animate__delay-1s">Proses Cepat, Mudah, dan Bebas Hambatan</p>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-10 font-black uppercase">
            <?php 
            $flows = [
                ['i' => 'file-circle-check', 't' => 'Validasi Dokumen', 'd' => 'Pengecekan kelengkapan berkas awal sesuai standar.', 'w' => 'Step 01'],
                ['i' => 'signature', 't' => 'Pesan Nama', 'd' => 'Estimasi waktu pengerjaan: 2 Hari Kerja.', 'w' => 'Step 02'],
                ['i' => 'file-invoice', 't' => 'Preview Draft', 'd' => 'Review draf minuta dalam waktu 1 Hari Kerja.', 'w' => 'Step 03'],
                ['i' => 'pen-nib', 't' => 'Tanda Tangan', 'd' => 'Proses penandatanganan berkas resmi oleh klien.', 'w' => 'Step 04'],
                ['i' => 'building-shield', 't' => 'Akta & SK', 'd' => 'Penerbitan SK Kemenkumham dalam 2 Hari Kerja.', 'w' => 'Step 05'],
                ['i' => 'id-card', 't' => 'NPWP Badan', 'd' => 'Proses pendaftaran NPWP dalam 1 Hari Kerja.', 'w' => 'Step 06'],
                ['i' => 'certificate', 't' => 'Penerbitan NIB', 'd' => 'Pendaftaran di portal OSS dalam 1 Hari Kerja.', 'w' => 'Step 07'],
                ['i' => 'truck-fast', 't' => 'Pengiriman', 'd' => 'Dokumen asli dikirim langsung ke alamat Anda.', 'w' => 'Step 08']
            ];
            $delay = 0;
            foreach($flows as $f): ?>
            <div class="step-card group bg-white p-12 rounded-[50px] border border-slate-100 shadow-lg relative flex flex-col items-center animate__animated animate__fadeInUp" style="animation-delay: <?= $delay ?>s">
                <span class="step-number absolute top-8 left-8 text-4xl font-black text-slate-100 transition-all duration-500"><?= $f['w'] ?></span>
                <div class="step-icon-bg w-20 h-20 bg-indigo-50 text-indigo-600 rounded-3xl flex items-center justify-center mb-8 transition-all duration-700 shadow-inner">
                    <i class="fas fa-<?= $f['i'] ?> text-3xl"></i>
                </div>
                <h3 class="text-lg font-black text-indigo-900 mb-4 tracking-tighter group-hover:text-indigo-600 transition-colors uppercase"><?= $f['t'] ?></h3>
                <p class="text-[10px] text-slate-500 font-bold leading-relaxed uppercase"><?= $f['d'] ?></p>
            </div>
            <?php $delay += 0.1; endforeach; ?>
        </div>
    </section>

    <section class="container mx-auto px-6 py-10 font-black uppercase">
        <div class="max-w-6xl mx-auto grid grid-cols-1 lg:grid-cols-2 gap-10 animate__animated animate__fadeInUp">
            <div class="bg-white p-12 rounded-[60px] border-l-8 border-orange-500 shadow-2xl relative overflow-hidden">
                <div class="absolute -right-10 -bottom-10 text-orange-500 opacity-5 text-9xl"><i class="fas fa-clipboard-list"></i></div>
                <h4 class="text-2xl font-black text-orange-500 mb-8 flex items-center gap-3 uppercase"><i class="fas fa-circle-info"></i> Catatan Penting</h4>
                <ul class="space-y-6 text-[11px] text-slate-600 font-bold leading-relaxed">
                    <li class="flex items-start gap-4 p-4 bg-orange-50 rounded-2xl transition hover:bg-orange-100 uppercase">
                        <span class="bg-orange-500 text-white w-6 h-6 rounded-lg flex items-center justify-center shrink-0">1</span>
                        <span>Proses pengerjaan dimulai setelah seluruh dokumen persyaratan lengkap dan valid.</span>
                    </li>
                    <li class="flex items-start gap-4 p-4 bg-orange-50 rounded-2xl transition hover:bg-orange-100 uppercase">
                        <span class="bg-orange-500 text-white w-6 h-6 rounded-lg flex items-center justify-center shrink-0">2</span>
                        <span>Tahap akta & SK dilakukan setelah draf disetujui dan pembayaran dilunasi.</span>
                    </li>
                    <li class="flex items-start gap-4 p-4 bg-orange-50 rounded-2xl transition hover:bg-orange-100 uppercase">
                        <span class="bg-orange-500 text-white w-6 h-6 rounded-lg flex items-center justify-center shrink-0">3</span>
                        <span>Proses NPWP Perusahaan memerlukan verifikasi kode OTP dari pihak customer.</span>
                    </li>
                </ul>
            </div>

            <div class="bg-indigo-900 p-12 rounded-[60px] text-white shadow-2xl relative overflow-hidden">
                <div class="absolute -right-10 -bottom-10 text-white opacity-5 text-9xl"><i class="fas fa-calendar-check"></i></div>
                <h4 class="text-2xl font-black text-indigo-400 mb-8 flex items-center gap-3 uppercase"><i class="fas fa-clock"></i> Ket. Tambahan</h4>
                <ul class="space-y-6 text-[11px] text-slate-300 font-bold leading-relaxed">
                    <li class="flex items-center gap-4 group uppercase">
                        <div class="w-10 h-10 rounded-full border border-indigo-500/50 flex items-center justify-center group-hover:bg-indigo-500 transition-all"><i class="fas fa-calendar-day"></i></div>
                        <span>Waktu pengerjaan dihitung hanya pada hari kerja (Senin s/d Jumat).</span>
                    </li>
                    <li class="flex items-center gap-4 group uppercase">
                        <div class="w-10 h-10 rounded-full border border-indigo-500/50 flex items-center justify-center group-hover:bg-indigo-500 transition-all"><i class="fas fa-calendar-xmark"></i></div>
                        <span>Hari Sabtu, Minggu, dan hari libur nasional tidak dihitung hari kerja.</span>
                    </li>
                    <li class="flex items-start gap-4 group uppercase">
                        <div class="w-10 h-10 rounded-full border border-indigo-500/50 flex items-center justify-center group-hover:bg-indigo-500 transition-all shrink-0"><i class="fas fa-triangle-exclamation"></i></div>
                        <span>Estimasi waktu bersifat dinamis tergantung pada kecepatan sistem pemerintah dan kebijakan terbaru.</span>
                    </li>
                </ul>
            </div>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-24 pb-12 px-6 uppercase font-black leading-tight animate__animated animate__fadeIn">
        <div class="container mx-auto">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-16 lg:gap-20 mb-24 text-center md:text-left">
                <div class="flex flex-col items-center md:items-start animate__animated animate__fadeInUp">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" class="h-20 mb-6 brightness-125 contrast-125">
                    <div class="flex flex-col mb-10">
                        <span class="text-5xl font-black tracking-tighter text-white leading-none">POP<span class="text-orange-500 underline">JASA</span></span>
                        <span class="text-[10px] font-black text-slate-400 tracking-[0.3em] mt-3 border-t border-white/10 pt-3">Solusi Perijinan Usaha Anda</span>
                    </div>
                    <div class="space-y-4 text-[13px] font-black text-slate-300 tracking-tighter mb-10 uppercase">
                        <p class="flex items-center gap-3"><i class="fas fa-phone-volume text-orange-500"></i> (031) 59181278</p>
                        <p class="flex items-center gap-3"><i class="fas fa-comment-dots text-orange-500"></i> WhatsApp : 081229995779</p>
                        <p class="flex items-center gap-3"><i class="fas fa-envelope-open-text text-orange-500"></i> popjasa@gmail.com</p>
                    </div>
                    <div class="flex gap-4">
                        <a href="#" class="sosmed-icon w-12 h-12 rounded-2xl bg-blue-600 flex items-center justify-center text-xl shadow-lg transition-all"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="sosmed-icon w-12 h-12 rounded-2xl bg-gradient-to-tr from-yellow-500 via-pink-600 to-purple-600 flex items-center justify-center text-xl shadow-lg transition-all"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="sosmed-icon w-12 h-12 rounded-2xl bg-black flex items-center justify-center text-xl border border-white/20 shadow-lg transition-all"><i class="fab fa-tiktok"></i></a>
                        <a href="#" class="sosmed-icon w-12 h-12 rounded-2xl bg-green-500 flex items-center justify-center text-xl shadow-lg transition-all"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>

                <div class="animate__animated animate__fadeInUp animate__delay-1s">
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter">Layanan Pengurusan<br>Legalitas Usaha</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Jasa Pembuatan CV</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Jasa Pengurusan NIB</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Jasa Pembuatan PT</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Jasa Pembuatan UD</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase leading-tight"><i class="fas fa-caret-right text-[8px]"></i> Jasa Pengurusan PIRT</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase leading-tight"><i class="fas fa-caret-right text-[8px]"></i> PT Perorangan</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> PT PMA</li>
                    </ul>
                </div>

                <div class="animate__animated animate__fadeInUp animate__delay-2s">
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none">Administrasi &<br>Perpajakan</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase leading-tight"><i class="fas fa-caret-right text-[8px]"></i> SPT Tahunan</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Tax Amnesty</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Pengukuhan PKP</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Pelaporan LKPM</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Pembuatan NPWP</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Kode Billing</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase"><i class="fas fa-caret-right text-[8px]"></i> Faktur Pajak</li>
                    </ul>
                </div>

                <div class="animate__animated animate__fadeInUp animate__delay-3s">
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none">Digital<br>Marketing</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase font-black"><i class="fas fa-caret-right text-[8px]"></i> Website Perusahaan</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase font-black leading-tight"><i class="fas fa-caret-right text-[8px]"></i> Company Profile</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase font-black"><i class="fas fa-caret-right text-[8px]"></i> Logo Usaha</li>
                        <li class="hover:text-orange-400 cursor-pointer transition flex items-center gap-2 uppercase font-black leading-tight"><i class="fas fa-caret-right text-[8px]"></i> Desain Flyer</li>
                    </ul>
                </div>
            </div>

            <div class="pt-12 border-t border-white/5 text-center text-slate-500 text-[11px] tracking-[0.5em] uppercase font-black">
                Copyright @2026 POPJASA - PROFESSIONAL LEGALITY SERVICES
            </div>
        </div>
    </footer>

    <a href="https://wa.me/6281229995779" class="fixed bottom-10 right-10 w-20 h-20 bg-green-500 text-white rounded-full flex items-center justify-center text-4xl shadow-3xl z-[999] hover:scale-110 transition border-8 border-[#001c3d] animate-bounce">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script>
        const btn = document.getElementById('hamburgerBtn');
        const menu = document.getElementById('mobileMenu');
        
        btn.addEventListener('click', (e) => {
            e.stopPropagation();
            menu.classList.toggle('active');
        });

        document.addEventListener('click', (e) => {
            if (menu.classList.contains('active') && !menu.contains(e.target) && e.target !== btn) {
                menu.classList.remove('active');
            }
        });
    </script>
</body>
</html>