CREATE DATABASE IF NOT EXISTS db_popjasa;
USE db_popjasa;

-- 1. Tabel Admin
CREATE TABLE `admin` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `admin` (`username`, `password`, `nama_lengkap`) VALUES 
('admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator');

-- 2. Tabel Artikel (Induk untuk Pin Artikel)
CREATE TABLE `articles` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `title` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `articles` (`title`) VALUES 
('Panduan Pendirian PT 2026'), ('Cara Daftar Merek HAKI'), ('Tips Pajak UMKM'), 
('Legalitas CV Terbaru'), ('Izin Edar BPOM'), ('Syarat OSS RBA'), 
('Manfaat NPWP Badan'), ('Pentingnya Akta Notaris');

-- 3. Tabel Slider Chat (Screenshot)
CREATE TABLE `home_chat_slides` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_chat_slides` (`image`) VALUES 
('chat1.jpg'), ('chat2.jpg'), ('chat3.jpg'), ('chat4.jpg'), 
('chat5.jpg'), ('chat6.jpg'), ('chat7.jpg'), ('chat8.jpg');

-- 4. Tabel Testimoni (Foto & Komen)
CREATE TABLE `home_testimonials` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `comment` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_testimonials` (`name`, `photo`, `comment`) VALUES 
('Budi Arto', 'user1.jpg', 'Sangat cepat pengerjaannya!'), ('Siska Wijaya', 'user2.jpg', 'Admin ramah dan solutif.'),
('Andi Pratama', 'user3.jpg', 'Harga termurah se-Indonesia.'), ('Maya Sari', 'user4.jpg', 'Sangat membantu UMKM.'),
('Hendra Kurniawan', 'user5.jpg', 'Prosesnya transparan.'), ('Rina Amalia', 'user6.jpg', 'Recomended banget pokoknya.'),
('Dedi Mulyadi', 'user7.jpg', 'Izin keluar tepat waktu.'), ('Siti Aminah', 'user8.jpg', 'Terima kasih Pop Jasa!');

-- 5. Tabel FAQ
CREATE TABLE `home_faq` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `question` varchar(255) NOT NULL,
  `answer` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_faq` (`question`, `answer`) VALUES 
('Berapa lama urus PT?', 'Sekitar 7-14 hari kerja.'), ('Bisa urus se-Indonesia?', 'Ya, kami melayani seluruh wilayah.'),
('Apakah harga nett?', 'Ya, sudah termasuk biaya pajak.'), ('Apa syarat buat CV?', 'KTP, KK, dan Nama CV.'),
('Bisa urus NPWP?', 'Bisa, satu paket dengan legalitas.'), ('Alamat kantor dimana?', 'Surabaya dan 9 cabang lain.'),
('Ada garansi?', 'Kami jamin dokumen asli & legal.'), ('Cara bayarnya gimana?', 'Bisa DP 50% di awal.');

-- 6. Tabel Pin Artikel (Penyimpan ID Artikel Terpilih)
CREATE TABLE `home_pinned_articles` (
  `slot` int(11) PRIMARY KEY,
  `article_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_pinned_articles` (`slot`, `article_id`) VALUES (1,1), (2,2), (3,3);