-- ==========================================================
-- 1. TABEL OTENTIKASI (PENTING UNTUK LOGIN)
-- ==========================================================
CREATE TABLE IF NOT EXISTS admin (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(100) NOT NULL, -- Email Admin
    password VARCHAR(255) NOT NULL, -- Password MD5
    nama_lengkap VARCHAR(100),
    last_login DATETIME
);

-- Masukkan akun default: admin@gmail.com | pass: 123456
-- Password e10adc3949ba59abbe56e057f20f883e adalah MD5 dari '123456'
INSERT INTO admin (username, password, nama_lengkap) 
VALUES ('admin@gmail.com', 'e10adc3949ba59abbe56e057f20f883e', 'Administrator POPJASA');


-- ==========================================================
-- 2. TABEL KONTEN HALAMAN UTAMA (HOME)
-- ==========================================================

-- Tabel Testimoni WhatsApp (Slide Chat)
CREATE TABLE IF NOT EXISTS home_chat (
    id INT PRIMARY KEY AUTO_INCREMENT,
    gambar VARCHAR(255),
    label VARCHAR(100)
);

-- Tabel Trusted Partners (Logo Mitra)
CREATE TABLE IF NOT EXISTS home_partners (
    id INT PRIMARY KEY AUTO_INCREMENT,
    gambar VARCHAR(255),
    label VARCHAR(100)
);

-- Tabel Testimoni Client (Apa Kata Mereka)
CREATE TABLE IF NOT EXISTS home_testimonials (
    id INT PRIMARY KEY AUTO_INCREMENT,
    gambar VARCHAR(255),
    nama VARCHAR(100),
    jabatan VARCHAR(100),
    komentar TEXT
);

-- Tabel FAQ
CREATE TABLE IF NOT EXISTS home_faq (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pertanyaan TEXT,
    jawaban TEXT
);


-- ==========================================================
-- 3. TABEL ARTIKEL / BLOG
-- ==========================================================
CREATE TABLE IF NOT EXISTS artikel (
    id INT PRIMARY KEY AUTO_INCREMENT,
    judul VARCHAR(255) NOT NULL,
    isi TEXT NOT NULL,
    gambar VARCHAR(255),
    kategori VARCHAR(50),
    tanggal DATE,
    is_pinned TINYINT(1) DEFAULT 0 -- 0: Biasa, 1: Pin di Atas
);