<?php
session_start();
include 'config/database.php';

// Mendapatkan ID dari URL (Contoh: detail-artikel.php?id=1)
$id = isset($_GET['id']) ? mysqli_real_escape_string($conn, $_GET['id']) : '';

// Query untuk mengambil data artikel spesifik (Logic akan aktif jika DB sudah siap)
// $query = "SELECT * FROM artikel WHERE id = '$id'";
// $result = mysqli_query($conn, $query);
// $data = mysqli_fetch_assoc($result);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BACA ARTIKEL - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    
    <style>
        body { font-family: 'Helvetica', 'Arial', sans-serif; scroll-behavior: smooth; background: #f8fafc; }
        * { font-style: normal !important; }
        .glass-nav { background: rgba(255, 255, 255, 0.98); backdrop-filter: blur(10px); }
        .article-content p { margin-bottom: 1.5rem; line-height: 1.8; color: #475569; text-transform: none; font-weight: 500; }
        .article-content h2 { margin-top: 2rem; margin-bottom: 1rem; color: #1e1b4b; font-weight: 900; }
        .bg-gradient-indigo { background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%); }
    </style>
</head>
<body class="font-black uppercase overflow-x-hidden">

<nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
    <div class="container mx-auto px-6 h-20 flex justify-between items-center">
        <div class="flex items-center gap-3">
            <a href="index.php" class="flex items-center gap-3">
                <img src="assets/images/pjs.png" alt="Logo POPJASA" class="h-12 object-contain">
                <div class="flex flex-col text-left leading-none">
                    <span class="text-xl font-extrabold tracking-tighter text-indigo-900">POPJASA</span>
                    <span class="text-[8px] font-bold text-orange-500 tracking-widest mt-1">Solusi Perijinan Usaha</span>
                </div>
            </a>
        </div>

        <div class="hidden lg:flex items-center space-x-6 font-bold text-slate-700 text-[13px]">
            <a href="index.php" class="hover:text-indigo-600 transition">Home</a>
            <a href="artikel.php" class="text-indigo-600 border-b-2 border-indigo-600 pb-1">Kembali Ke List</a>
        </div>

        <div class="flex items-center gap-4">
            <a href="https://wa.me/6281229995779" class="bg-green-500 text-white px-5 py-2.5 rounded-full font-black shadow-lg hover:bg-green-600 transition text-[10px] flex items-center gap-2">
                <i class="fab fa-whatsapp text-lg"></i> Tanya Admin
            </a>
        </div>
    </div>
</nav>

<main class="container mx-auto px-6 py-12 lg:py-20">
    <div class="max-w-4xl mx-auto">
        
        <nav class="flex gap-2 text-[10px] text-slate-400 mb-8 animate__animated animate__fadeIn">
            <a href="index.php" class="hover:text-indigo-600">HOME</a>
            <span>/</span>
            <a href="artikel.php" class="hover:text-indigo-600">ARTIKEL</a>
            <span>/</span>
            <span class="text-indigo-600">DETAIL KONTEN</span>
        </nav>

        <header class="mb-12 animate__animated animate__fadeInUp">
            <span class="bg-indigo-100 text-indigo-600 px-4 py-1 rounded-full text-[9px] font-black tracking-widest mb-6 inline-block">LEGALITAS USAHA</span>
            <h1 class="text-3xl lg:text-5xl font-black text-indigo-900 leading-tight tracking-tighter mb-6">
                Regulasi Terbaru Pendaftaran PT Dan CV Di Tahun 2026
            </h1>
            <div class="flex items-center gap-6 text-slate-400 text-[10px] font-bold border-y border-slate-100 py-4">
                <span class="flex items-center gap-2"><i class="far fa-calendar-alt text-orange-500"></i> 24 DESEMBER 2025</span>
                <span class="flex items-center gap-2"><i class="far fa-user text-orange-500"></i> ADMIN POPJASA</span>
                <span class="flex items-center gap-2"><i class="far fa-eye text-orange-500"></i> 1,240 VIEWS</span>
            </div>
        </header>

        <div class="rounded-[50px] overflow-hidden shadow-2xl mb-12 animate__animated animate__zoomIn">
            <img src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=1200" alt="Main Article" class="w-full h-auto object-cover max-h-[500px]">
        </div>

        <article class="article-content animate__animated animate__fadeInUp animate__delay-1s">
            <p>
                Selamat datang di era baru perizinan usaha Indonesia. Pemerintah telah memperbarui sistem OSS RBA untuk tahun 2026 guna mempercepat proses integrasi data antara Kemenkumham dan Direktorat Jenderal Pajak. Hal ini bertujuan agar para pengusaha UMKM dapat memiliki legalitas yang kuat dalam waktu kurang dari 24 jam.
            </p>
            
            <h2>Keuntungan Memiliki PT Perorangan</h2>
            <p>
                Salah satu poin utama dalam regulasi 2026 adalah kemudahan pendirian PT Perorangan. Pengusaha tidak lagi diwajibkan memiliki partner atau akta notaris yang rumit untuk skala usaha kecil. Cukup dengan NIB dan pernyataan mandiri, entitas hukum Anda sudah diakui oleh negara.
            </p>

            <blockquote class="bg-indigo-50 border-l-8 border-indigo-600 p-8 rounded-3xl my-10">
                <p class="text-indigo-900 font-black italic text-lg mb-0 uppercase">"Legalitas bukan sekadar dokumen, melainkan fondasi keamanan aset dan kepercayaan client kepada bisnis Anda."</p>
            </blockquote>

            <p>
                Bagi Anda yang masih bingung mengenai alur pendaftaran, POPJASA siap membantu mendampingi proses pengurusan hingga tuntas. Kami memastikan seluruh dokumen Anda tervalidasi dan sesuai dengan kode KBLI terbaru.
            </p>
        </article>

        <div class="mt-16 pt-8 border-t border-slate-200 flex flex-col sm:flex-row justify-between items-center gap-6 animate__animated animate__fadeInUp">
            <h4 class="text-xs text-indigo-900 font-black">BAGIKAN WAWASAN INI:</h4>
            <div class="flex gap-4">
                <a href="#" class="w-10 h-10 rounded-full bg-blue-600 text-white flex items-center justify-center hover:scale-110 transition"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="w-10 h-10 rounded-full bg-green-500 text-white flex items-center justify-center hover:scale-110 transition"><i class="fab fa-whatsapp"></i></a>
                <a href="#" class="w-10 h-10 rounded-full bg-sky-500 text-white flex items-center justify-center hover:scale-110 transition"><i class="fab fa-twitter"></i></a>
            </div>
        </div>

    </div>
</main>

<footer class="bg-[#001c3d] text-white pt-20 pb-10 px-6 mt-20">
    <div class="container mx-auto text-center">
        <img src="assets/images/pjs.png" class="h-16 mx-auto mb-6 brightness-125">
        <p class="text-[10px] tracking-[0.4em] opacity-50 mb-8 uppercase">Copyright @2026 www.popjasa.id</p>
    </div>
</footer>

</body>
</html>