<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Layanan Perpajakan - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { 
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; 
            scroll-behavior: smooth; 
        }
        .bg-gradient-indigo { background: linear-gradient(135deg, #0f172a 0%, #1e1b4b 50%, #312e81 100%); }
        .glass-nav { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
        
        /* Dropdown Desktop */
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }

        /* Mobile Menu */
        #mobileMenu { 
            transition: all 0.3s ease-in-out; 
            max-height: 0; 
            opacity: 0;
            pointer-events: none;
            overflow: hidden;
        }
        #mobileMenu.active { 
            max-height: 100vh; 
            opacity: 1;
            pointer-events: auto;
        }

        /* Sosmed Animation */
        .sosmed-icon { transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .sosmed-icon:hover { transform: translateY(-8px) scale(1.15); filter: brightness(1.2); box-shadow: 0 10px 20px rgba(0,0,0,0.2); }
        
        /* Force Reset Italic */
        .italic, i { font-style: normal !important; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                    <div class="flex flex-col text-left leading-none">
                        <span class="text-xl font-extrabold tracking-tighter text-indigo-900 uppercase">POPJASA</span>
                        <span class="text-[8px] font-bold text-orange-500 uppercase tracking-widest mt-1 leading-none">Solusi Perijinan Usaha</span>
                    </div>
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm uppercase font-black">
                <a href="index.php" class="hover:text-indigo-600 transition">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-indigo-600 transition py-8 tracking-wider text-xs font-black">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 uppercase font-black text-left leading-tight">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-t border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-y border-slate-50">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-indigo-600 uppercase text-xs font-black">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-indigo-600 uppercase text-xs font-black">Tentang Kami</a>
                <a href="#" class="hover:text-indigo-600 uppercase text-xs font-black">Program Affiliate</a>
                <a href="#artikel" class="hover:text-indigo-600 uppercase text-xs font-black">Artikel</a>
            </div>

            <div class="flex items-center gap-4 uppercase font-black">
                <a href="https://wa.me/6281229995779" class="hidden sm:flex bg-green-500 text-white px-5 py-2.5 rounded-full font-black shadow-lg hover:bg-green-600 transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp"></i> Konsultasi
                </a>
                <button id="hamburgerBtn" class="lg:hidden text-indigo-900 text-2xl focus:outline-none">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>

        <div id="mobileMenu" class="lg:hidden bg-white border-t border-slate-100 shadow-xl absolute w-full left-0 uppercase font-black">
            <div class="flex flex-col p-6 space-y-4 font-black uppercase text-xs tracking-widest leading-tight">
                <a href="index.php" class="py-2 border-b border-slate-50 leading-tight">Beranda</a>
                <div onclick="document.getElementById('mobileSub').classList.toggle('hidden')" class="py-2 border-b border-slate-50 flex justify-between items-center cursor-pointer">
                    <span>Layanan</span> <i class="fas fa-chevron-down text-[10px]"></i>
                </div>
                <div id="mobileSub" class="hidden flex flex-col pl-4 space-y-3 bg-slate-50 p-4 rounded-xl font-black text-left">
                    <a href="jasa-perizinan.php">Jasa Perizinan</a>
                    <a href="izin-lanjutan.php">Jasa Lanjutan</a>
                    <a href="perpajakan.php">Perpajakan</a>
                    <a href="digital-marketing.php">Digital Marketing</a>
                </div>
                <a href="alur-proses.php" class="py-2 border-b border-slate-50 leading-tight">Alur Proses</a>
                <a href="tentang-kami.php" class="py-2 border-b border-slate-50 leading-tight">Tentang Kami</a>
                <a href="#" class="py-2 border-b border-slate-50 leading-tight">Program Affiliate</a>
                <a href="#artikel" class="py-2 border-b border-slate-50 leading-tight">Artikel</a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-12 uppercase font-black">
        <div class="bg-blue-600 rounded-[40px] overflow-hidden flex flex-col lg:flex-row items-center relative min-h-[400px]">
            <div class="p-12 lg:w-3/5 text-white z-10 leading-tight">
                <h1 class="text-4xl lg:text-5xl font-black mb-6 uppercase leading-tight">Pelaporan dan<br>Administrasi Pajak</h1>
                <ul class="space-y-3 mb-10 text-sm font-black tracking-tighter">
                    <li class="flex items-center gap-2"><i class="fas fa-check-circle"></i> Akurat, Tepat Waktu & Aman</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check-circle"></i> Konsultan Pajak Profesional</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check-circle"></i> Solusi Pajak Badan & Pribadi</li>
                </ul>
                <button class="bg-white text-blue-600 px-10 py-4 rounded-2xl font-black text-xs uppercase shadow-xl hover:bg-slate-100 transition">
                    Konsultasi Pajak Sekarang
                </button>
            </div>
            <div class="lg:w-2/5 w-full h-full min-h-[300px] relative font-black">
                <img src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover lg:absolute lg:inset-0 brightness-110 contrast-110" style="clip-path: polygon(0% 0%, 100% 0%, 100% 100%, 15% 100%);">
            </div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 text-center uppercase font-black">
        <h2 class="text-2xl font-black mb-4">Layanan Perpajakan POP JASA</h2>
        <p class="text-slate-500 max-w-2xl mx-auto mb-16 font-bold text-[10px] md:text-sm leading-relaxed uppercase">Kami hadir membantu bisnis Anda patuh terhadap regulasi perpajakan Indonesia dengan layanan yang mudah dan transparan.</p>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 tracking-tighter font-black">
            <?php 
            $pajak = [
                ['title' => 'SPT Tahunan', 'price' => '500.000', 'points' => ['SPT Pribadi/Badan', 'E-Filing Pajak', 'Review Data']],
                ['title' => 'Tax Amnesty', 'price' => '1.500.000', 'points' => ['Ungkap Harta', 'Surat Keterangan', 'Bebas Sanksi']],
                ['title' => 'Laporan LKPM', 'price' => '1.200.000', 'points' => ['Input OSS RBA', 'Laporan Realisasi', 'Kepatuhan BKPM']],
                ['title' => 'Faktur Pajak', 'price' => '800.000', 'points' => ['Aktivasi PKP', 'Sertifikat El', 'Aplikasi E-Faktur']]
            ];
            foreach($pajak as $p): ?>
            <div class="bg-white rounded-[32px] border border-slate-200 p-8 shadow-sm hover:border-indigo-600 transition flex flex-col font-black">
                <h3 class="font-black text-indigo-900 mb-2 uppercase text-xs leading-tight"><?= $p['title'] ?></h3>
                <div class="text-xl font-black text-blue-600 mb-6 tracking-tighter">Rp <?= $p['price'] ?></div>
                <ul class="text-left space-y-3 mb-8 flex-grow opacity-70">
                    <?php foreach($p['points'] as $pt): ?>
                    <li class="text-[9px] flex items-start gap-2">
                        <i class="fas fa-check text-green-500 mt-1"></i> <?= $pt ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <button class="bg-indigo-600 text-white w-full py-3 rounded-xl font-black text-[9px] uppercase">Pilih Paket</button>
            </div>
            <?php endforeach; ?>
        </div>
    </section>

    <section id="artikel" class="bg-slate-100 py-24 px-6 border-t border-slate-200 uppercase font-black">
        <div class="container mx-auto">
            <h2 class="text-center text-3xl font-black uppercase mb-16 tracking-tighter">Informasi Pajak</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-10 uppercase font-black">
                <?php for($j=1;$j<=3;$j++): ?>
                <div class="bg-white rounded-[40px] overflow-hidden border border-slate-200 shadow-sm group hover:shadow-2xl transition duration-500 uppercase">
                    <div class="h-48 bg-slate-300 overflow-hidden relative uppercase font-black">
                         <img src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?auto=format&fit=crop&q=80&w=600" class="w-full h-full object-cover group-hover:scale-110 transition duration-1000">
                    </div>
                    <div class="p-8 font-black uppercase">
                        <h3 class="font-black text-sm mb-4 leading-tight uppercase tracking-tighter">Cara Lapor SPT Badan 2026</h3>
                        <p class="text-slate-500 text-[10px] font-bold mb-6 tracking-tight opacity-70 leading-relaxed uppercase">Simak panduan lengkap pengisian SPT Tahunan untuk menghindari denda...</p>
                        <a href="#" class="text-indigo-600 font-black text-[9px] border-b-2 border-indigo-600 pb-1 tracking-widest">Selengkapnya</a>
                    </div>
                </div>
                <?php endfor; ?>
            </div>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-24 pb-12 px-6 uppercase font-black leading-tight border-t border-white/5">
        <div class="container mx-auto">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-12 lg:gap-20 mb-24 text-center md:text-left font-black uppercase">
                <div class="flex flex-col items-center md:items-start uppercase font-black">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" class="h-20 mb-6 brightness-125 contrast-125 uppercase font-black">
                    <div class="flex flex-col mb-8 uppercase font-black">
                        <span class="text-4xl font-black tracking-tighter text-white leading-none uppercase">POP<span class="text-orange-500 underline">JASA</span></span>
                        <span class="text-[10px] font-black text-slate-400 tracking-[0.3em] mt-3 border-t border-white/10 pt-3 uppercase">Solusi Perijinan Usaha Anda</span>
                    </div>
                    <div class="space-y-4 text-[13px] font-black text-slate-300 tracking-tighter mb-8 uppercase">
                        <p>Phone : (031) 59181278</p>
                        <p>WhatsApp / SMS Center : 081229995779</p>
                        <p>Email : popjasa@gmail.com</p>
                    </div>
                    <div class="flex gap-4 pt-4 uppercase font-black">
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-gradient-to-tr from-yellow-500 via-pink-600 to-purple-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-black flex items-center justify-center text-lg border border-white/20 shadow-lg transition font-black"><i class="fab fa-tiktok"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-green-500 flex items-center justify-center text-lg shadow-lg transition uppercase font-black"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>

                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none font-black uppercase">Layanan Pengurusan<br>Legalitas Usaha</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pembuatan CV</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pengurusan NIB</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pembuatan PT</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pembuatan UD</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black leading-tight">Jasa Pengurusan PIRT</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black leading-tight">Jasa Pendirian PT Perorangan</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pendirian PT PMA</li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none font-black uppercase">Layanan Pelaporan dan<br>Administrasi Perpajakan</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider font-black">
                        <li class="hover:text-orange-400 cursor-pointer leading-tight uppercase font-black">Jasa Pelaporan SPT Tahunan</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pengampunan Pajak</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pengukuhan PKP</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pelaporan LKPM</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Pembuatan NPWP</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Kode Billing Pajak</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Jasa Faktur Pajak</li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none tracking-widest font-black uppercase">Layanan Digital<br>Marketing</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider font-black">
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Website Perusahaan</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Company Profile</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black">Logo Usaha</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase font-black leading-tight">Desain Flyer Promosi</li>
                    </ul>
                </div>
            </div>
            <div class="pt-12 border-t border-white/5 text-center text-slate-500 text-[11px] tracking-[0.4em] uppercase font-black">
                Copyright @2026 www.popjasa.id
            </div>
        </div>
    </footer>

    <a href="https://wa.me/6281229995779" class="fixed bottom-10 right-10 w-16 h-16 bg-green-500 text-white rounded-full flex items-center justify-center text-4xl shadow-3xl z-[999] hover:scale-110 transition border-8 border-[#001c3d] animate-bounce uppercase font-black">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script>
        const btn = document.getElementById('hamburgerBtn');
        const menu = document.getElementById('mobileMenu');
        btn.addEventListener('click', (e) => { e.stopPropagation(); menu.classList.toggle('active'); });
        document.addEventListener('click', (e) => { if (menu.classList.contains('active') && !menu.contains(e.target) && e.target !== btn) menu.classList.remove('active'); });
    </script>
</body>
</html>