<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Program Affiliate - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    
    <style>
        body { 
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; 
            scroll-behavior: smooth; 
        }
        .bg-gradient-indigo { background: linear-gradient(135deg, #0f172a 0%, #1e1b4b 50%, #312e81 100%); }
        .glass-nav { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        #mobileMenu { transition: all 0.3s ease-in-out; max-height: 0; opacity: 0; pointer-events: none; overflow: hidden; }
        #mobileMenu.active { max-height: 100vh; opacity: 1; pointer-events: auto; }
        .sosmed-icon { transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .sosmed-icon:hover { transform: translateY(-8px) scale(1.15); filter: brightness(1.2); box-shadow: 0 10px 20px rgba(0,0,0,0.2); }
        
        /* Swiper Custom Style */
        .swiper-pagination-bullet-active { background: #4f46e5 !important; }
        .affiliate-card { transition: all 0.5s ease; border-radius: 50px; overflow: hidden; }
        .affiliate-card:hover { transform: translateY(-10px); border-color: #4f46e5; }

        /* Force Reset Italic */
        .italic, i, body, .font-black { font-style: normal !important; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center font-black uppercase">
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                    <div class="flex flex-col text-left leading-none font-black">
                        <span class="text-xl font-extrabold tracking-tighter text-indigo-900 uppercase">POPJASA</span>
                        <span class="text-[8px] font-bold text-orange-500 tracking-widest mt-1 uppercase">Solusi Perijinan Usaha</span>
                    </div>
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm uppercase">
                <a href="index.php" class="hover:text-indigo-600 transition">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-indigo-600 transition py-8 tracking-wider text-xs">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 font-black text-left leading-tight uppercase">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-t border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-indigo-600 uppercase text-xs">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-indigo-600 uppercase text-xs">Tentang Kami</a>
                <a href="program-affiliate.php" class="hover:text-indigo-600 uppercase text-xs">Program Affiliate</a>
                <a href="artikel.php" class="hover:text-indigo-600 uppercase text-xs">Artikel</a>
            </div>

            <div class="flex items-center gap-4 uppercase">
                <a href="https://wa.me/6281229995779" class="hidden sm:flex bg-green-500 text-white px-5 py-2.5 rounded-full font-black shadow-lg hover:bg-green-600 transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp"></i> Konsultasi Wa Gratis
                </a>
                <button id="hamburgerBtn" class="lg:hidden text-indigo-900 text-2xl focus:outline-none transition hover:rotate-90"><i class="fas fa-bars"></i></button>
            </div>
        </div>

        <div id="mobileMenu" class="lg:hidden bg-white border-t border-slate-100 shadow-xl absolute w-full left-0 font-black uppercase">
            <div class="flex flex-col p-6 space-y-4 text-xs tracking-widest leading-tight">
                <a href="index.php" class="py-2 border-b border-slate-50">Beranda</a>
                <div onclick="document.getElementById('mobileSub').classList.toggle('hidden')" class="py-2 border-b border-slate-50 flex justify-between items-center cursor-pointer">
                    <span>Layanan</span> <i class="fas fa-chevron-down text-[10px]"></i>
                </div>
                <div id="mobileSub" class="hidden flex flex-col pl-4 space-y-3 bg-slate-50 p-4 rounded-xl text-left font-black">
                    <a href="jasa-perizinan.php">Jasa Perizinan</a>
                    <a href="izin-lanjutan.php">Jasa Lanjutan</a>
                    <a href="perpajakan.php">Perpajakan</a>
                    <a href="digital-marketing.php">Digital Marketing</a>
                </div>
                <a href="alur-proses.php" class="py-2 border-b border-slate-50">Alur Proses</a>
                <a href="tentang-kami.php" class="py-2 border-b border-slate-50">Tentang Kami</a>
                <a href="program-affiliate.php" class="py-2 border-b border-slate-50">Program Affiliate</a>
                <a href="artikel.php" class="py-2 border-b border-slate-50">Artikel</a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-20 text-center font-black uppercase">
        <h1 class="text-4xl lg:text-5xl font-extrabold text-indigo-900 mb-6 tracking-tighter">Program Affiliate POP JASA</h1>
        <p class="text-slate-500 max-w-2xl mx-auto mb-16 font-bold text-sm leading-relaxed uppercase">Rekomendasikan Layanan Kami Dan Dapatkan Keuntungan Finansial Melalui Program Kemitraan Strategis</p>

        <div class="swiper affiliateSwiper pb-16">
            <div class="swiper-wrapper">
                <?php 
                $tiers = [
                    ['img' => 'https://images.unsplash.com/photo-1553729459-efe14ef6055d?w=800&q=80', 'title' => 'Affiliate Bronze', 'price' => 'Komisi 5%'],
                    ['img' => 'https://images.unsplash.com/photo-1560472355-536de3962603?w=800&q=80', 'title' => 'Affiliate Silver', 'price' => 'Komisi 10%'],
                    ['img' => 'https://images.unsplash.com/photo-1559526324-4b87b5e36e44?w=800&q=80', 'title' => 'Affiliate Gold', 'price' => 'Komisi 15%'],
                    ['img' => 'https://images.unsplash.com/photo-1579389083078-4e7018379f7e?w=800&q=80', 'title' => 'Affiliate Platinum', 'price' => 'Komisi 20%']
                ];
                foreach($tiers as $t): ?>
                <div class="swiper-slide px-4">
                    <div class="affiliate-card bg-white border border-slate-200 shadow-xl p-0 h-full flex flex-col items-center">
                        <div class="w-full h-64 overflow-hidden mb-8">
                            <img src="<?= $t['img'] ?>" alt="Affiliate Tier" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700">
                        </div>
                        <div class="p-8 pt-0 text-center uppercase">
                            <h3 class="text-xl font-black text-indigo-900 mb-2 uppercase">Gambar Dan Label Harga</h3>
                            <div class="text-3xl font-black text-orange-500 mb-6 tracking-tighter"><?= $t['price'] ?></div>
                            <button class="bg-indigo-600 text-white px-10 py-4 rounded-2xl font-black text-xs uppercase hover:bg-indigo-700 transition shadow-lg">Daftar Partner</button>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-24 pb-12 px-6 uppercase font-black leading-tight border-t border-white/5">
        <div class="container mx-auto">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-12 lg:gap-20 mb-24 text-center md:text-left">
                <div class="flex flex-col items-center md:items-start uppercase font-black">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" class="h-20 mb-6 brightness-125 contrast-125 uppercase font-black">
                    <div class="flex flex-col mb-8 font-black">
                        <span class="text-4xl font-black tracking-tighter text-white leading-none uppercase">POP<span class="text-orange-500 underline">JASA</span></span>
                        <span class="text-[10px] font-black text-slate-400 tracking-[0.3em] mt-3 border-t border-white/10 pt-3 uppercase">Solusi Perijinan Usaha Anda</span>
                    </div>
                    <div class="space-y-4 text-[13px] font-black text-slate-300 tracking-tighter mb-8 uppercase font-black">
                        <p>(031) 59181278</p>
                        <p>WHATSAPP : 081229995779</p>
                        <p>POPJASA@GMAIL.COM</p>
                    </div>
                    <div class="flex gap-4 pt-4 uppercase font-black">
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-gradient-to-tr from-yellow-500 via-pink-600 to-purple-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-black flex items-center justify-center text-lg border border-white/20 shadow-lg transition font-black"><i class="fab fa-tiktok"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-green-500 flex items-center justify-center text-lg shadow-lg transition uppercase font-black"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>

                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase leading-none font-black">LAYANAN PENGURUSAN <br> LEGALITAS USAHA</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider uppercase">
                        <li class="hover:text-orange-400 cursor-pointer">JASA PEMBUATAN CV</li>
                        <li class="hover:text-orange-400 cursor-pointer">JASA PENGURUSAN NIB</li>
                        <li class="hover:text-orange-400 cursor-pointer">JASA PEMBUATAN PT</li>
                        <li class="hover:text-orange-400 cursor-pointer">JASA PEMBUATAN UD</li>
                        <li class="hover:text-orange-400 cursor-pointer">JASA PENGURUSAN PIRT</li>
                        <li class="hover:text-orange-400 cursor-pointer">PT PERORANGAN</li>
                        <li class="hover:text-orange-400 cursor-pointer">PT PMA</li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase leading-none text-left font-black">ADMINISTRASI & <br> PERPAJAKAN</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider uppercase">
                        <li class="hover:text-orange-400 cursor-pointer uppercase">SPT TAHUNAN</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">TAX AMNESTY</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">PENGUKUKUHAN PKP</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">PELAPORAN LKPM</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">PEMBUATAN NPWP</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">KODE BILLING</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">FAKTUR PAJAK</li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase leading-none font-black">DIGITAL <br> MARKETING</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider uppercase font-black">
                        <li class="hover:text-orange-400 cursor-pointer">WEBSITE PERUSAHAAN</li>
                        <li class="hover:text-orange-400 cursor-pointer">COMPANY PROFILE</li>
                        <li class="hover:text-orange-400 cursor-pointer">LOGO USAHA</li>
                        <li class="hover:text-orange-400 cursor-pointer leading-tight font-black uppercase">DESAIN FLYER</li>
                    </ul>
                </div>
            </div>
            <div class="pt-12 border-t border-white/5 text-center text-slate-500 text-[11px] tracking-[0.4em] font-black uppercase">
                Copyright @2026 www.popjasa.id
            </div>
        </div>
    </footer>

    <a href="https://wa.me/6281229995779" class="fixed bottom-10 right-10 w-16 h-16 bg-green-500 text-white rounded-full flex items-center justify-center text-4xl shadow-3xl z-[999] hover:scale-110 transition border-8 border-[#001c3d] animate-bounce font-black">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        const btn = document.getElementById('hamburgerBtn');
        const menu = document.getElementById('mobileMenu');
        btn.addEventListener('click', (e) => { e.stopPropagation(); menu.classList.toggle('active'); });
        document.addEventListener('click', (e) => { if (menu.classList.contains('active') && !menu.contains(e.target) && e.target !== btn) menu.classList.remove('active'); });

        var swiper = new Swiper(".affiliateSwiper", {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: { delay: 4000, disableOnInteraction: false },
            pagination: { el: ".swiper-pagination", clickable: true },
            breakpoints: {
                640: { slidesPerView: 1, spaceBetween: 20 },
                768: { slidesPerView: 2, spaceBetween: 30 },
                1024: { slidesPerView: 3, spaceBetween: 40 }
            }
        });
    </script>
</body>
</html>